using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.GamerServices;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Media;

namespace BreadAndCheese {
    /// <summary>
    /// To jest gwny typ Twojej gry.
    /// </summary>
    public class BreadAndCheeseGame : Microsoft.Xna.Framework.Game {
        GraphicsDeviceManager graphics;
        SpriteBatch spriteBatch;

        // wiat gry
        Texture2D cheeseTexture;
        Rectangle cheeseRectangle;
        float cheeseX;
        float cheeseXSpeed;
        float cheeseY;
        float cheeseYSpeed;
        float cheeseWidthFactor = 0.05f;
        float cheeseTicksToCrossScreen = 200.0f;

        // Ustawienia ekranu
        float displayWidth;
        float displayHeight;
        float overScanPercentage = 10.0f;
        float minDisplayX;
        float maxDisplayX;
        float minDisplayY;
        float maxDisplayY;

        float getPercentage(float percentage, float inputValue) {
            return (inputValue * percentage) / 100;
        }

        private void setupScreen() {
            displayWidth = graphics.GraphicsDevice.Viewport.Width;
            displayHeight = graphics.GraphicsDevice.Viewport.Height;
            float xOverscanMargin =
                    getPercentage(overScanPercentage, displayWidth) / 2.0f;
            float yOverscanMargin =
                    getPercentage(overScanPercentage, displayHeight) / 2.0f;

            minDisplayX = xOverscanMargin;
            minDisplayY = yOverscanMargin;

            maxDisplayX = displayWidth - xOverscanMargin;
            maxDisplayY = displayHeight - yOverscanMargin;
        }

        void scaleSprites() {
            cheeseRectangle.Width = (int) ((displayWidth * cheeseWidthFactor) + 0.5f);
            float aspectRatio = (float) cheeseTexture.Width / cheeseTexture.Height;
            cheeseRectangle.Height = (int) ((cheeseRectangle.Width / aspectRatio) + 0.5f);
            cheeseX = minDisplayX;
            cheeseY = minDisplayY;
            cheeseXSpeed = displayWidth / cheeseTicksToCrossScreen;
            cheeseYSpeed = cheeseXSpeed;
        }

        public BreadAndCheeseGame() {
            graphics = new GraphicsDeviceManager(this);
            Content.RootDirectory = "Content";
        }

        /// <summary>
        /// Umoliwia ewentualn inicjalizacj przed uruchomieniem waciwej gry.
        /// W tym miejscu mona odnale wszystkie wymagane zasoby i zaadowa treci
        /// related content. Wywoanie metody base.Initialize spowoduje przeszukanie wszystkich komponentw
        /// i ich inicjalizacj.
        /// </summary>
        protected override void Initialize() {
            setupScreen();

            base.Initialize();
        }

        /// <summary>
        /// Metoda LoadContent jest wywoywana tylko raz dla caej gry i jako taka jest waciwym miejscem
        /// dla kodu adujcego tre.
        /// </summary>
        protected override void LoadContent() {
            // Tworzy nowy obiekt klasy SpriteBatch, ktrego mona uywa do rysowania tekstur.
            spriteBatch = new SpriteBatch(GraphicsDevice);

            cheeseTexture = Content.Load<Texture2D > ("Images/Cheese");

            scaleSprites();

        }

        /// <summary>
        /// Metoda UnloadContent jest wywoywana tylko raz dla caej gry i jako taka jest waciwym miejscem
        /// dla kodu usuwajcego ca tre z pamici.
        /// </summary>
        protected override void UnloadContent() {
            // TODO: Naley usun ca tre, ktr nie zarzdza ContentManager.
        }

        /// <summary>
        /// Umoliwia grze wykonywanie logiki zwizanej z aktualizacj wiata gry,
        /// sprawdzaniem kolizji, pobieraniem danych wejciowych czy odtwarzaniem dwikw.
        /// </summary>
        /// <param name="gameTime">Udostpnia wartoci reprezentujce biecy czas.</param>
        protected override void Update(GameTime gameTime) {
            // Pozwala opuci gr
            if (GamePad.GetState(PlayerIndex.One).Buttons.Back == ButtonState.Pressed)
                this.Exit();

            cheeseX = cheeseX + cheeseXSpeed;
            cheeseY = cheeseY + cheeseYSpeed;
            cheeseRectangle.X = (int) (cheeseX + 0.5f);
            cheeseRectangle.Y = (int) (cheeseY + 0.5f);

            if (cheeseX + cheeseRectangle.Width >= maxDisplayX) {
                cheeseXSpeed = cheeseXSpeed * -1;
            }

            if (cheeseX <= minDisplayX) {
                cheeseXSpeed = cheeseXSpeed * -1;
            }

            if (cheeseY + cheeseRectangle.Height >= maxDisplayY) {
                cheeseYSpeed = cheeseYSpeed * -1;
            }

            if (cheeseY <= minDisplayY) {
                cheeseYSpeed = cheeseYSpeed * -1;
            }

            base.Update(gameTime);
        }

        /// <summary>
        /// Ta metoda jest wywoywana w momencie, w ktrym gra musi narysowa swj wiat.
        /// </summary>
        /// <param name="gameTime">Udostpnia wartoci reprezentujce biecy czas.</param>
        protected override void Draw(GameTime gameTime) {
            GraphicsDevice.Clear(Color.CornflowerBlue);

            spriteBatch.Begin();

            spriteBatch.Draw(cheeseTexture, cheeseRectangle, Color.White);

            spriteBatch.End();

            base.Draw(gameTime);
        }
    }
}
